Ext.data.JsonP.sol_common_ConfigMixin({"tagname":"class","name":"sol.common.ConfigMixin","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.Config.js","href":"lib_sol.common.Config.html#sol-common-ConfigMixin"}],"elojc":true,"eloas":true,"eloix":true,"requires":["sol.common.Config","sol.common.ObjectUtils","sol.common.StringUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"mixin","tagname":"property","owner":"sol.common.ConfigMixin","id":"property-mixin","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"extractConfigPart","tagname":"method","owner":"sol.common.ConfigMixin","id":"method-extractConfigPart","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"mergeConfiguration","tagname":"method","owner":"sol.common.ConfigMixin","id":"method-mergeConfiguration","meta":{}},{"name":"parseConfiguration","tagname":"method","owner":"sol.common.ConfigMixin","id":"method-parseConfiguration","meta":{}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.ConfigMixin","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.ConfigMixin</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.Config' rel='sol.common.Config' class='docClass'>sol.common.Config</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectUtils' rel='sol.common.ObjectUtils' class='docClass'>sol.common.ObjectUtils</a></div><div class='dependency'><a href='#!/api/sol.common.StringUtils' rel='sol.common.StringUtils' class='docClass'>sol.common.StringUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.Config.html#sol-common-ConfigMixin' target='_blank'>lib_sol.common.Config.js</a></div></pre><div class='doc-contents'><p>Utility functions to mix into objects and help working with configurations.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div><div id='property-mixin' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ConfigMixin'>sol.common.ConfigMixin</span><br/><a href='source/lib_sol.common.Config.html#sol-common-ConfigMixin-property-mixin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ConfigMixin-property-mixin' class='name expandable'>mixin</a> : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>true</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-extractConfigPart' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ConfigMixin'>sol.common.ConfigMixin</span><br/><a href='source/lib_sol.common.Config.html#sol-common-ConfigMixin-method-extractConfigPart' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ConfigMixin-method-extractConfigPart' class='name expandable'>extractConfigPart</a>( <span class='pre'>config, property</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Extracts a part of a bigger configuration object. ...</div><div class='long'><p>Extracts a part of a bigger configuration object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>The hole configuration object</p>\n</div></li><li><span class='pre'>property</span> : String<div class='sub-desc'><p>The property (or path in dot notation), which holds the desired property part</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-mergeConfiguration' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ConfigMixin'>sol.common.ConfigMixin</span><br/><a href='source/lib_sol.common.Config.html#sol-common-ConfigMixin-method-mergeConfiguration' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ConfigMixin-method-mergeConfiguration' class='name expandable'>mergeConfiguration</a>( <span class='pre'>configuration</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Merge configuration ...</div><div class='long'><p>Merge configuration</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>configuration</span> : Object|String<div class='sub-desc'><p>A JavaScript Object, or a JSON String</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>merged configuration</p>\n</div></li></ul></div></div></div><div id='method-parseConfiguration' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ConfigMixin'>sol.common.ConfigMixin</span><br/><a href='source/lib_sol.common.Config.html#sol-common-ConfigMixin-method-parseConfiguration' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ConfigMixin-method-parseConfiguration' class='name expandable'>parseConfiguration</a>( <span class='pre'>configuration, allProps</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Parses the configuration from an Object or a JSON String. ...</div><div class='long'><p>Parses the configuration from an Object or a JSON String.</p>\n\n<p>Additionally, a JSON file can be specified, to load configuration from.</p>\n\n<pre><code>{\n  $config: \"4711\",          // (optional) an objId, GUID or ARCPATH to a JSON file\n  $property: \"configParts.part1\",  // (optional) if specified, and the property is an Object, this will be used, instead of the hole JSON file content (can reference sub-objects by using '.' notation)\n  extraParam: \"extra\"  // (optional) all properties, without `$` prefix, will be written into the result.config Object (possibly overwriting values from the JSON file)\n}\n</code></pre>\n\n<p>If the JSON file (with objId=4711) would contain something like this:</p>\n\n<pre><code>{\n  \"someProperty\": \"string\",\n  \"configParts\": {\n    \"part1\": {\n      \"firstParam\": \"first\",\n      \"secondParam\": \"second\"\n    }\n  }\n}\n</code></pre>\n\n<p>The returned Object would look like this:</p>\n\n<pre><code>{\n  $config: \"4711\",\n  $property: \"configParts.part1\",\n  config: {\n    firstParam: \"first\",\n    secondParam: \"second\",\n    extraParam: \"extra\"\n  }\n}\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>configuration</span> : Object|String<div class='sub-desc'><p>A JavaScript Object, or a JSON String</p>\n</div></li><li><span class='pre'>allProps</span> : Boolean<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true,"eloix":true,"elojc":true,"singleton":true}});